%% Vrification des donnes acquises par le systme 1024
% Analyse des digits
% On suppose que les donnes ont t acquises correctement (en terme de
% nombre d'octets) et en format int32 avec au plus le compteur A
clear all
close all
%% VALEUR A ADAPTER
name = 'test1';
%% Lecture de l'en-tte
name_dat = strcat(name,'.dat');
name_en_tete = strcat(name,'.Mu');
fid = fopen(name_en_tete,'rb');
header.annee = fread(fid,1,'uint16');
header.mois = fread(fid,1,'uint16');
header.jour_semaine = fread(fid,1,'uint16');
header.jour = fread(fid,1,'uint16');
header.heure = fread(fid,1,'uint16');
header.minute = fread(fid,1,'uint16');
header.seconde = fread(fid,1,'uint16');
header.ms = fread(fid,1,'uint16');
header.micros = fread(fid,1024,'uint8');
header.VA = fread(fid,16,'uint8');
header.compteurs = fread(fid,4,'uint8');
header.frequence = fread(fid,1,'single');
header.nb_ech = fread(fid,1,'uint32');
header.duree = fread(fid,1,'single');
header.type = fread(fid,1,'uint8');
header.commentaires = fread(fid,1024,'*char');
fclose(fid);
if (header.type ~= 0)
    disp('Les donnes ne sont pas en format Int32')
    return    
end
%%  Lecture donnes
nb_compteursBCD = sum(header.compteurs(2:4));
nb_VA = sum(header.VA);
nb_micros =  sum(header.micros);
nb_voies = nb_micros + nb_VA + header.compteurs(1);
if (nb_compteursBCD > 0)
    disp('Prsence de compteur(s) B, C, D. Enregistrement  refaire !');
    return
end
if (nb_micros + nb_VA == 0)
    disp('Ni micro, ni voie analogique acquis. Enregistrement  refaire !');
    return
end
nb_ech = header.nb_ech;
name_dat = strcat(name,'.dat');
fid = fopen(name_dat,'rb');
mat=fread(fid,nb_ech*nb_voies,'*uint32');
fclose(fid);
Fe = header.frequence;     % freq echant. en Hz
mat=reshape(mat,nb_voies,[]);
% Elimination du compteur A
if (header.compteurs(1) == 1)
    mat = mat(2:end,:);
    nb_voies = nb_voies - 1;
end
%% Dtermination de la valeur moyenne des 24 premiers bits
taux = zeros(24,nb_voies);
for i = 1 : 24
   taux(i,:) = mean(bitget(mat(:,:),i),2);
end
%% Reprage des voies
num_mic = zeros(1,1024);
num_VA = zeros(1,16);
k = 0;
for i = 0:3
   for j = 1:256
       if(header.micros(j+256*i) == 1)
          k = k + 1;
          num_mic(i * 256 + j) = k;
       else
          num_mic(i * 256 + j) = -1; 
       end
   end
   for j = 1:4
       if(header.VA(j+4*i) == 1)
          k = k + 1;
          num_VA(j+4*i) = k;
       else
           num_VA(j+4*i) = -1;
       end
   end
end
taux_tries = zeros(24,1040);
for i = 1:1024
    if (num_mic(i) >0)
        taux_tries(:,i) = taux(:,num_mic(i));
    end
end
for i = 1:16
    if (num_VA(i) >0)
        taux_tries(:,i+1024) = taux(:,num_VA(i));
    end
end
%% Figures
scrsz = get(0,'ScreenSize');    %dtermination de la taille de l'cran
fen_aff = [scrsz(3)/8 scrsz(4)/8 3*scrsz(3)/4 3*scrsz(4)/4];
figure('Position',fen_aff,'NumberTitle','off','Name','Bits 0->7','Color','White');
plot(taux_tries(1:8,:)');
set(gca,'FontName','Century Gothic','FontSize',14);
xlabel('Voie');
legend('0','1','2','3','4','5','6','7','Location','eastoutside')     
title('Bits 0->7');
figure('Position',fen_aff,'NumberTitle','off','Name','Bits 8->15','Color','White');
plot(taux_tries(9:16,:)');
set(gca,'FontName','Century Gothic','FontSize',14);
xlabel('Voie');
legend('8','9','10','11','12','13','14','15','Location','eastoutside')     
title('Bits 8->15');
figure('Position',fen_aff,'NumberTitle','off','Name','Bits 16->23','Color','White');
plot(taux_tries(17:24,:)');
set(gca,'FontName','Century Gothic','FontSize',14);
xlabel('Voie');
legend('16','17','18','19','20','21','22','23','Location','eastoutside')     
title('Bits 16->23');